UI.Separator()
setDefaultTab("PVP")
UI.Label("Avoid Waves (Retao)")

AvoidWaves = {
    enabled = false,
    lastMove = 0,
    moveDelay = 300, -- Delay between movements in milliseconds
}

-- Helper function to get relative direction
local function getRelativeDirection(attacker, player)
    local ax, ay = attacker:getPosition().x, attacker:getPosition().y
    local px, py = player:getPosition().x, player:getPosition().y
    
    if ax == px then
        return ay > py and "south" or "north"
    elseif ay == py then
        return ax > px and "east" or "west"
    end
    return nil
end

-- Helper function to find safe position to move
local function findSafePosition(direction)
    local player = g_game.getLocalPlayer()
    if not player then return nil end
    
    local pos = player:getPosition()
    local possibleMoves = {}
    
    if direction == "north" or direction == "south" then
        -- When attacker is north/south, move east or west
        local east = {x = pos.x + 1, y = pos.y, z = pos.z}
        local west = {x = pos.x - 1, y = pos.y, z = pos.z}
        
        if g_map.getTile(east) and g_map.getTile(east):isWalkable() then
            table.insert(possibleMoves, east)
        end
        if g_map.getTile(west) and g_map.getTile(west):isWalkable() then
            table.insert(possibleMoves, west)
        end
    else
        -- When attacker is east/west, move north or south
        local north = {x = pos.x, y = pos.y - 1, z = pos.z}
        local south = {x = pos.x, y = pos.y + 1, z = pos.z}
        
        if g_map.getTile(north) and g_map.getTile(north):isWalkable() then
            table.insert(possibleMoves, north)
        end
        if g_map.getTile(south) and g_map.getTile(south):isWalkable() then
            table.insert(possibleMoves, south)
        end
    end
    
    return #possibleMoves > 0 and possibleMoves[math.random(#possibleMoves)] or nil
end

macro(100, "Avoid Waves", function()
    if not AvoidWaves.enabled then return end
    
    local player = g_game.getLocalPlayer()
    if not player then return end
    
    local attackers = g_map.getSpectators(player:getPosition(), false)
    for _, creature in ipairs(attackers) do
        if creature:isPlayer() and creature:isAttacking() and creature:getTarget() == player then
            local direction = getRelativeDirection(creature, player)
            if direction then
                -- Only move if we haven't moved recently
                if AvoidWaves.lastMove + AvoidWaves.moveDelay < now then
                    local safePos = findSafePosition(direction)
                    if safePos then
                        g_game.walk(getDirectionFromPos(player:getPosition(), safePos))
                        AvoidWaves.lastMove = now
                        return
                    end
                end
            end
        end
    end
end)

-- Toggle for the macro
UI.Separator()
local enableButton = UI.Button("Avoid Waves ON/OFF", function()
    AvoidWaves.enabled = not AvoidWaves.enabled
end)